@
@
@    Copyright 2009 TheSeven
@
@
@    This file is part of TheSeven's iBugger.
@
@    TheSeven's iBugger is free software: you can redistribute it and/or
@    modify it under the terms of the GNU General Public License as
@    published by the Free Software Foundation, either version 3 of the
@    License, or (at your option) any later version.
@
@    TheSeven's iBugger is distributed in the hope that it will be useful,
@    but WITHOUT ANY WARRANTY; without even the implied warranty of
@    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
@    GNU General Public License for more details.
@
@    You should have received a copy of the GNU General Public License along
@    with TheSeven's iBugger.  If not, see <http://www.gnu.org/licenses/>.
@
@
 

start:
MOV R3, #0xD3
MSR CPSR_c, R3             @ Supervisor mode, no IRQs, no FIQs
MOV R1, #5
MRC p15, 0, R0,c1,c0
BIC R0, R0, R1
MCR p15, 0, R0,c1,c0       @ Disable the Protection Unit and DCache
MOV R12, #0
MCR p15, 0, R12,c7,c10,4   @ Flush write buffer
MCR p15, 0, R12,c7,c5      @ Flush ICache

MOV R8, #0x38800000
MOV R9, #0x3C400000
ADD R1, R9, #0x00100000    @ Enable all clocks
STR R12, [R1,#0x28]
STR R12, [R1,#0x40]

MOV R11, #1
MOV R5, #0x00000800
ADD R1, R5, #02
STR R1, [R8,#0x804]
BL sleep10ms
STR R12, [R9]              @ USB2 PHY: Power on
BL sleep10ms
STR R11, [R9,#0x08]        @ USB2 PHY: Assert Software Reset
BL sleep10ms
STR R12, [R9,#0x08]        @ USB2 PHY: Deassert Software Reset
BL sleep10ms
STR R12, [R9,#0x04]        @ USB2 PHY: Clock is 48MHz
BL sleep10ms
STR R11, [R8,#0x10]        @ USB2 Gadget: Assert Core Software Reset
waitcorereset:
LDR R2, [R8,#0x10]         @ USB2 Gadget: Wait for Core to reset
TST R2, #1
BNE waitcorereset
TST R2, #0x80000000
BEQ waitcorereset
LDR R2, [R8,#0x44]         @ USB2 Gadget: No idea what these are good for???
LDR R2, [R8,#0x48]
LDR R2, [R8,#0x4C]
LDR R2, [R8,#0x50]
LDR R2, [R8,#0x14]         @ USB2 Gadget: Interrupt Status Register
MOV R2, #0x26
STR R2, [R8,#0x08]         @ USB2 Gadget: DMA Enable, Burst Length: 4, Mask Interrupts
MOV R2, #0x1400
ADD R2, R2, #8
STR R2, [R8,#0x0C]         @ USB2 Gadget: PHY IF is 16bit, Turnaround 5 (???)
BL sleep10ms
STR R5, [R8,#0x804]
@ fallthrough

mainloop:
  LDR R3, [R8,#0x14]         @ Global USB interrupts
  TST R3, #0x00001000        @ BUS reset
  BEQ noreset
    MOV R2, #4
    STR R2, [R8,#0x800]        @ USB2 Gadget: Device Address 0, STALL on non-zero length status stage
    MOV R2, #0x8000
    STR R2, [R8,#0x900]        @ USB2 Gadget: Endpoint 0 IN Control: ACTIVE
    STR R2, [R8,#0xB00]        @ USB2 Gadget: Endpoint 0 OUT Control: ACTIVE
    SUB R5, R12, #1
    STR R5, [R8,#0x908]        @ USB2 Gadget: Endpoint 0 IN Interrupt: ALL
    STR R5, [R8,#0xB08]        @ USB2 Gadget: Endpoint 0 OUT Interrupt: ALL
    LDR R2, val_20080040
    STR R2, [R8,#0xB10]        @ USB2 Gadget: Endpoint 0 OUT Transfer Size: 64 Bytes, 1 Packet, 1 Setup Packet
    MOV R2, #0x08000000
    STR R2, [R8,#0xB14]        @ USB2 Gadget: Endpoint 0 OUT DMA Address: 0x08000000
    LDR R2, [R8,#0xB00]
    ORR R2, #0x84000000
    STR R2, [R8,#0xB00]        @ USB2 Gadget: Endpoint 0 OUT Control: ENABLE CLEARNAK
    MOV R2, #0x88000
    ADD R2, #0x210
    STR R2, [R8,#0xB40]        @ USB2 Gadget: Endpoint 2 OUT Control: ACTIVE BULK, 528 byte packets
    STR R5, [R8,#0xB48]        @ USB2 Gadget: Endpoint 2 OUT Interrupt: ALL
    LDR R2, val_00080210
    STR R2, [R8,#0xB50]        @ USB2 Gadget: Endpoint 2 OUT Transfer Size: 528 Bytes, 1 Packet
    MOV R2, #0x08200000
    STR R2, [R8,#0xB54]        @ USB2 Gadget: Endpoint 2 OUT DMA Address: 0x08200000
    LDR R2, [R8,#0xB40]
    ORR R2, #0x94000000
    STR R2, [R8,#0xB40]        @ USB2 Gadget: Endpoint 2 OUT Control: ENABLE CLEARNAK DATA0
    STR R5, [R8,#0x810]        @ USB2 Gadget: IN Endpoint Interrupt Mask: ALL
    STR R5, [R8,#0x814]        @ USB2 Gadget: OUT Endpoint Interrupt Mask: ALL
    STR R5, [R8,#0x81C]        @ USB2 Gadget: Enable interrupts on all endpoints
  noreset:
  TST R3, #0x00040000        @ IN endpoint event
  BEQ noinevent
    LDR R4, [R8,#0x908]        @ Just ACK them all...
    STR R4, [R8,#0x908]
    LDR R4, [R8,#0x928]
    STR R4, [R8,#0x928]
  noinevent:
  TST R3, #0x00080000        @ OUT endpoint event
  BEQ nooutevent
    LDR R4, [R8,#0xB08]
    MOVS R4, R4                @ Event on OUT EP0
    BEQ noep0out
      TST R4, #8                 @ SETUP phase done
      BEQ controldone
        MOV R5, #0x08000000
        LDRB R6, [R5,#0x01]        @ Get request type
        CMP R6, #0
          BEQ GET_STATUS
        CMP R6, #1
          BEQ CLEAR_FEATURE
        CMP R6, #3
          BEQ SET_FEATURE
        CMP R6, #5
          BEQ SET_ADDRESS
        CMP R6, #6
          BEQ GET_DESCRIPTOR
        CMP R6, #8
          BEQ GET_CONFIGURATION
        CMP R6, #9
          BEQ SET_CONFIGURATION
        ctrlstall:
        LDR R1, [R8,#0x900]
        ORR R1, #0x00200000
        STR R1, [R8,#0x900]        @ Stall IN EP0
        LDR R1, [R8,#0xB00]
        ORR R1, #0x00200000
        STR R1, [R8,#0xB00]        @ Stall OUT EP0
      controldone:
      LDR R1, val_20080040
      STR R1, [R8,#0xB10]        @ OUT EP0: 64 Bytes, 1 Packet, 1 Setup Packet
      MOV R1, #0x08000000
      STR R1, [R8,#0xB14]        @ OUT EP0: DMA address
      LDR R1, [R8,#0xB00]
      ORR R1, R1, #0x84000000
      STR R1, [R8,#0xB00]        @ OUT EP0: Enable ClearNAK
    noep0out:
    STR R4, [R8,#0xB08]        @ ACK it, whatever it was...
    LDR R4, [R8,#0xB48]
    MOVS R4, R4                @ Event on OUT EP1
    BEQ noep1out
      TST R4, #1                 @ XFER complete
      BEQ datadone
        MOV R0, #0x08200000
        LDR R1, [R0]
        LDR R2, [R0,#0x04]
        CMP R1, #1                 @ RELOAD
          BEQ start
        CMP R1, #2                 @ RESET
          LDREQ PC, val_08206AB4
        CMP R1, #6                 @ EXECUTE
          SUBEQ LR, PC, #exec-start
          MCREQ p15, 0, R12,c7,c5      @ Flush ICache
          exec:
          MOVEQ PC, R2
        CMP R1, #4                 @ FASTWRITE
        BNE nofastwrite
          LDR R1, [R0,#0x08]
          ADD R0, R0, #0x10
          fastcopydata:
            LDR R5, [R0], #4
            STR R5, [R2], #4
            SUBS R1, R1, #1
          BNE fastcopydata
          MCREQ p15, 0, R12,c7,c10,4   @ Flush write buffer
          B datadone
        nofastwrite:
        CMP R1, #5                 @ WRITE
        BNE datadone
          LDR R1, [R0,#0x08]
          ADD R0, R0, #0x10
          copydata:
            LDRB R5, [R0], #1
            STRB R5, [R2], #1
            SUBS R1, R1, #1
          BNE copydata
          MCREQ p15, 0, R12,c7,c10,4   @ Flush write buffer
      datadone:
      LDR R1, val_00080210
      STR R1, [R8,#0xB50]        @ OUT EP2: 528 Bytes, 1 Packet
      MOV R1, #0x08200000
      STR R1, [R8,#0xB54]        @ Out EP2: DMA address
      LDR R1, [R8,#0xB40]
      ORR R1, R1, #0x84000000
      STR R1, [R8,#0xB40]        @ Out EP2: Enable ClearNAK
    noep1out:
    STR R4, [R8,#0xB48]        @ ACK it, whatever it was...
  nooutevent:
  STR R3, [R8,#0x14]         @ ACK it, whatever it was...
B mainloop


sleep10ms:
  mov R0, #0x00010000
@ fallthrough

sleeploop:
  SUBS R0, R0, #1
  BNE sleeploop
MOV PC, LR

GET_DESCRIPTOR:
  LDRB R7, [R5,#3]           @ Descriptor type
  CMP R7, #1
    BEQ GET_DEVICE_DESCRIPTOR
  CMP R7, #2
    BEQ GET_CONFIGURATION_DESCRIPTOR
  CMP R7, #3
  BNE ctrlstall
@ fallthrough

GET_STRING_DESCRIPTOR:
  LDRB R7, [R5,#2]           @ String descriptor index
  CMP R7, #1
    BEQ GET_VENDOR_STRING
  CMP R7, #2
    BEQ GET_DEVICE_STRING
@ fallthrough

GET_LANG_STRING:
  ADD R0, PC, #langstringdescriptor-GET_LANG_STRING-8
  MOV R1, #0x00000004
B senddescriptor

GET_VENDOR_STRING:
  MOV R1, #0x00000026
B senddevname

GET_DEVICE_STRING:
  MOV R1, #0x0000003E
@ fallthrough

senddevname:
  ADD R0, PC, #devnamestringdescriptor-senddevname-8
  STRB R1, [R0]
B senddescriptor

GET_DEVICE_DESCRIPTOR:
  ADD R0, PC, #devicedescriptor-GET_DEVICE_DESCRIPTOR-8
  MOV R1, #0x00000012
B senddescriptor

GET_CONFIGURATION_DESCRIPTOR:
  ADD R0, PC, #configurationdescriptor-GET_CONFIGURATION_DESCRIPTOR-8
  MOV R1, #0x00000020
@ fallthrough

senddescriptor:
  LDRH R5, [R5,#0x06]        @ Requested length
  CMP R5, R1
  MOVLO R1, R5
  MOV R2, #0x08100000
  ADD R6, R1, R2
  copydescriptor:
    LDR R5, [R0], #4
    STR R5, [R2], #4
    CMP R2, R6
  BCC copydescriptor
B ctrlsend

GET_STATUS:
  LDRB R1, [R5]
  CMP R1, #0x80
  MOV R1, #0x00000001
  SUBNE R1, R1, R1
  MOV R0, #0x08100000
  STR R1, [R0]
  MOV R1, #0x00000002
B ctrlsend

CLEAR_FEATURE:
  LDRB R2, [R5]
  CMP R2, #2
  LDREQ R2, [R5,#2]
  ANDEQ R2, #0xFF7FFFFF
  CMPEQ R2, #0x00010000
@ fallthrough

SET_CONFIGURATION:
  LDREQ R2, [R8,#0x920]
  ORREQ R2, #0x10000000
  STREQ R2, [R8,#0x920]      @ EP1 IN: Set DATA0 PID
  LDREQ R2, [R8,#0xB20]
  ORREQ R2, #0x10000000
  STREQ R2, [R8,#0xB20]      @ EP1 OUT: Set DATA0 PID
B SET_FEATURE              @ zero-length ACK

SET_ADDRESS:
  LDRH R2, [R5,#0x02]        @ new address
  LDR R1, [R8,#0x800]
  BIC R1, R1, #0x000007F0
  ORR R1, R1, R2,LSL#4
  STR R1, [R8,#0x800]        @ set new address
@ fallthrough

SET_FEATURE:
  MOV R1, #0                 @ zero-length ACK
B ctrlsend

GET_CONFIGURATION:
  MOV R1, #0x00000001
  STR R1, [R0]
@ fallthrough

ctrlsend:
  MCR p15, 0, R12,c7,c10,4   @ Flush write buffer
  MOV R0, #0x08100000        @ Buffer to be sent
  MOV R2, #0x00008000
  STR R2, [R8,#0x900]        @ EP0 IN: ACTIVE
  ORR R1, R1, #0x00080000    @ 1 Packet
  STR R1, [R8,#0x910]        @ EP0 IN: 1 Packet, Size as in R1
  STR R0, [R8,#0x914]        @ EP0 IN: DMA address
  LDR R1, [R8,#0x900]
  ORR R1, R1, #0x84000000
  STR R1, [R8,#0x900]        @ EP0 IN: Enable ClearNAK
B controldone

val_00080210:
.word 0x00080210

val_20080040:
.word 0x20080040

val_08206AB4:
.word 0x08206AB4

devicedescriptor:
.word 0x02000112
.word 0x40FFFFFF
.word 0x4245FFFF
.word 0x02010001
.word 0x00010100

configurationdescriptor:
.word 0x00200209
.word 0xC0000101
.word 0x00040932
.word 0xFFFF0200
.word 0x050700FF
.word 0x06100202
.word 0x81050701
.word 0x01061002

langstringdescriptor:
.word 0x04090304

devnamestringdescriptor:
.word 0x0054033E
.word 0x00650068
.word 0x00650053
.word 0x00650076
.word 0x0027006E
.word 0x00200073
.word 0x00420069
.word 0x00670075
.word 0x00650067
.word 0x00200072
.word 0x006F004C
.word 0x00640061
.word 0x00720065
.word 0x00760020
.word 0x002E0030
.word 0x00000031
