#!/usr/bin/env python
#
#
#    Copyright 2009 TheSeven
#
#
#    This file is part of TheSeven's iBugger.
#
#    TheSeven's iBugger is free software: you can redistribute it and/or
#    modify it under the terms of the GNU General Public License as
#    published by the Free Software Foundation, either version 3 of the
#    License, or (at your option) any later version.
#
#    TheSeven's iBugger is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License along
#    with TheSeven's iBugger.  If not, see <http://www.gnu.org/licenses/>.
#
#


import sys
import math
import struct
import usb


def upload(dev, file):
  f = open(file, "rb")
  handle = dev.open()
  handle.setConfiguration(1)
  handle.claimInterface(0)

  offset = 0x22000000
  while True:
    data = f.read(512)
    if (data == ""): break
    handle.bulkWrite(2, struct.pack("<IIII", 4, offset, int(math.ceil(len(data) / 4)), 0) + data)
    offset += len(data)

  handle.bulkWrite(2, struct.pack("<II", 6, 0x22000020))

  handle.releaseInterface()


if len(sys.argv) != 2:
  print "Please provide a filename to upload as an argument"
  exit(2)

busses = usb.busses()
 
for bus in busses:
  devices = bus.devices
  for dev in devices:
    if dev.idVendor == 0xffff and dev.idProduct == 0x4245:
      print "Found iBugger loader, version", dev.deviceVersion
      upload(dev, sys.argv[1])
      exit(0)

print "No iBugger capable device found!"
exit(1)
